; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

;-| AI Motions |--------------------------------------------------------
[Command]
Name = "AI0"
Command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
Time = 0
[Command]
Name = "AI1"
Command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
Time = 0
[Command]
Name = "AI2"
Command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
Time = 0
[Command]
Name = "AI3"
Command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
Time = 0
[Command]
Name = "AI4"
Command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
Time = 0
[Command]
Name = "AI5"
Command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
Time = 0
[Command]
Name = "AI6"
Command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
Time = 0
[Command]
Name = "AI7"
Command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
Time = 0
[Command]
Name = "AI8"
Command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
Time = 0
[Command]
Name = "AI9"
Command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
Time = 0
[Command]
Name = "AI10"
Command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
Time = 0
[Command]
Name = "AI11"
Command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
Time = 0
[Command]
Name = "AI12"
Command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
Time = 0
[Command]
Name = "AI13"
Command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
Time = 0
[Command]
Name = "AI14"
Command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
Time = 0
[Command]
Name = "AI15"
Command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
Time = 0
[Command]
Name = "AI16"
Command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
Time = 0
[Command]
Name = "AI17"
Command = a,B,c,x,y,z,s,B,D,F,U,a,b,c,x,y,z,s,s
Time = 0
[Command]
Name = "AI18"
Command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
Time = 0
[Command]
Name = "AI19"
Command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
Time = 0
[Command]
Name = "AI20"
Command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
Time = 0
[Command]
Name = "AI21"
Command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
Time = 0
[Command]
Name = "AI22"
Command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
Time = 0
[Command]
Name = "AI23"
Command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
Time = 0
[Command]
Name = "AI24"
Command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
Time = 0
[Command]
Name = "AI25"
Command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
Time = 0
[Command]
Name = "AI26"
Command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
Time = 0
[Command]
Name = "AI27"
Command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
Time = 0
[Command]
Name = "AI28"
Command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
Time = 0
[Command]
Name = "AI29"
Command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
Time = 0
[Command]
Name = "AI30"
Command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
Time = 0
[Command]
Name = "AI31"
Command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
Time = 0
[Command]
Name = "AI32"
Command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
Time = 0
[Command]
Name = "AI33"
Command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
Time = 0
[Command]
Name = "AI34"
Command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
Time = 0
[Command]
Name = "AI35"
Command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
Time = 0
[Command]
Name = "AI36"
Command = z,z,z,z,z,z,a,a,a,z,z,z,z,z,z,z,z,z,z
Time = 0
[Command]
Name = "AI37"
Command = z,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,z,z,z
Time = 0
[Command]
Name = "AI38"
Command = z,z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z
Time = 0

[command]
name = "fwd"
command = F
time = 1

[command]
name = "back"
command = B
time = 1

[command]
name = "up"
command = U
time = 1

[command]
name = "down"
command = D
time = 1


;-| Super Motions |--------------------------------------------------------
[Command]
name = "Hupper_a"
command = ~D, F, D, F, a
time = 25

[Command]
name = "Hupper_b"
command = ~D, F, D, F, b
time = 25

[Command]
name = "Hupper_c"
command = ~D, F, D, F, a+b
time = 25


[Command]
name = "HQCF_x"
command = ~F, B, D, F, x
time = 25


[Command]
name = "HQCF_y"
command = ~F, B, D, F, y
time = 25

[Command]
name = "HQCF_z"
command = ~F, B, D, F, x+y
time = 25

[Command]
name = "Cho_a"
command = ~D, DF, F, D, DB, B, a
time = 25

[Command]
name = "Cho_b"
command = ~D, DF, F, D, DB, B, b
time = 25

[Command]
name = "Cho_c"
command = ~D, DF, F, D, DB, B, a+b
time = 25

;-| Special Motions |------------------------------------------------------
[Command]
name = "upper_x"
command = ~F, D, DF, x

[Command]
name = "upper_y"
command = ~F, D, DF, y

[Command]
name = "upper_xy"
command = ~F, D, DF, x+y

[Command]
name = "double"
command = ~F, D, DF, y

[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y

[Command]
name = "QCB_a"
command = D, DF, F, a

[Command]
name = "QCB_b"
command = D, DF, F, b

[Command]
name = "QCB_a"
command = D, DF, F, a

[Command]
name = "QCB_x"
command = F, D, B, x
time = 20

[Command]
name = "QCB_y"
command = F, D, B, y
time = 20

[Command]
name = "FDBF_a"
command = F, D, B, F~, a
time = 25

[Command]
name = "FDBF_b"
command = F, D, B, F~, b
time = 25

[Command]
name = "FDBF_ab"
command = F, D, B, F~, a+b
time = 25


[Command]
name = "DB_x"
command = D, B~, x
time = 15

[Command]
name = "DB_y"
command = D, B~, y
time = 15

[Command]
name = "DB_xy"
command = D, B~, x+y
time = 20

[Command]
name = "DB_a"
command = D, B~, a
time = 15

[Command]
name = "DB_b"
command = D, B~, b
time = 15

[Command]
name = "longjump"
command = D, $U
time = 18

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "groggyrecover"
command = F,B
time = 20


[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 25

[Command]
name = "HighJump"
command = D, $U
time = 25

;-| 2/3 Button Combination |-----------------------------------------------

[Command]
name = "recovery"
command = a+x
time = 1

[Command]
name = "recovery"
command = c
time = 1

[Command]
name = "Roll"
command = /F,a+x
time = 1

[Command]
name = "Roll"
command = /F,c
time = 1

[Command]
name = "back-Roll"
command = /B,a+x
time = 1

[Command]
name = "back-Roll"
command = /B,c
time = 1

[Command]
name = "yb"
command = y+b
time = 1

[Command]
name = "yb"
command = z
time = 1

[Command]
name = "charge1"
command = /x
time = 1

[Command]
name = "charge2"
command = /y
time = 1


;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "fwd_a"
command = /F,a
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_start"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------

[Command]
name = "Upward"
command = /DF
time = 1

[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;------------------------ For KOF Series Only
[Command]
name = "holdupfwd"
command = /UF
time = 1

[Command]
name = "holdupback"
command = /UB
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]
;===========================================================================
;---------------------------------------------------------------------------
;ʹ 3
[State -1, HUpper]
type = ChangeState
value = 2200
triggerall = !var(30)
triggerall = Power >= 3000
triggerall = command = "Cho_c"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200)|| (stateno = 230) || (stateno = 240)|| (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = StateNo = 3000 && ((Anim = 3000 && (AnimElemTime(6) >= 0 && AnimElemTime(22) < 0))||(Anim = 3010 && (AnimElemTime(6) >= 0 && AnimElemTime(30) < 0))||(Anim = 3020 && (AnimElemTime(6) >= 0 && AnimElemTime(38) < 0)))
trigger4 = StateNo = 3100 && ((Anim = 3100 && (AnimElemTime(6) >= 1 && AnimElemTime(15) < 0)))
trigger5 = StateNo = 1000 && (AnimElemTime(5) >= 0 && AnimElemTime(7) < 0)
trigger6 = StateNo = 1100 && (AnimElemTime(2) >= 0 && AnimElemTime(3) < 0)
trigger7 = StateNo = 1500 && (AnimElemTime(6) >= 0 && AnimElemTime(9) < 0)
;---------------------------------------------------------------------------
;ʹ 2
[State -1, HUpper]
type = ChangeState
value = 2100
triggerall = !var(30)
triggerall = Power >= 2000
triggerall = command = "Cho_b"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200)|| (stateno = 230) || (stateno = 240)|| (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = StateNo = 3000 && ((Anim = 3000 && (AnimElemTime(6) >= 0 && AnimElemTime(22) < 0))||(Anim = 3010 && (AnimElemTime(6) >= 0 && AnimElemTime(30) < 0))||(Anim = 3020 && (AnimElemTime(6) >= 0 && AnimElemTime(38) < 0)))
trigger4 = StateNo = 3100 && ((Anim = 3100 && (AnimElemTime(6) >= 1 && AnimElemTime(15) < 0)))
trigger5 = StateNo = 1000 && (AnimElemTime(5) >= 0 && AnimElemTime(7) < 0)
trigger6 = StateNo = 1100 && (AnimElemTime(2) >= 0 && AnimElemTime(3) < 0)
trigger7 = StateNo = 1500 && (AnimElemTime(6) >= 0 && AnimElemTime(9) < 0)
;---------------------------------------------------------------------------
;ʹ 1
[State -1, HUpper]
type = ChangeState
value = 2000
triggerall = !var(30)
triggerall = Power >= 1000
triggerall = command = "Cho_a"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200)|| (stateno = 230) || (stateno = 240)|| (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = StateNo = 3000 && ((Anim = 3000 && (AnimElemTime(6) >= 0 && AnimElemTime(22) < 0))||(Anim = 3010 && (AnimElemTime(6) >= 0 && AnimElemTime(30) < 0))||(Anim = 3020 && (AnimElemTime(6) >= 0 && AnimElemTime(38) < 0)))
trigger4 = StateNo = 3100 && ((Anim = 3100 && (AnimElemTime(6) >= 1 && AnimElemTime(15) < 0)))
trigger5 = StateNo = 1000 && (AnimElemTime(5) >= 0 && AnimElemTime(7) < 0)
trigger6 = StateNo = 1100 && (AnimElemTime(2) >= 0 && AnimElemTime(3) < 0)
trigger7 = StateNo = 1500 && (AnimElemTime(6) >= 0 && AnimElemTime(9) < 0)

;---------------------------------------------------------------------------
;пջı3
[State -1, HUpper]
type = ChangeState
value = 3120
triggerall = !var(30)
triggerall = Power >= 3000
triggerall = command = "HQCF_z" 
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200)|| (stateno = 230) || (stateno = 240)|| (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = StateNo = 3000 && ((Anim = 3000 && (AnimElemTime(6) >= 0 && AnimElemTime(22) < 0))||(Anim = 3010 && (AnimElemTime(6) >= 0 && AnimElemTime(30) < 0))||(Anim = 3020 && (AnimElemTime(6) >= 0 && AnimElemTime(38) < 0)))
trigger4 = StateNo = 3100 && ((Anim = 3100 && (AnimElemTime(6) >= 1 && AnimElemTime(15) < 0)))
trigger5 = StateNo = 1000 && (AnimElemTime(5) >= 0 && AnimElemTime(7) < 0)
trigger6 = StateNo = 1100 && (AnimElemTime(2) >= 0 && AnimElemTime(3) < 0)
trigger7 = StateNo = 1500 && (AnimElemTime(6) >= 0 && AnimElemTime(9) < 0)

;---------------------------------------------------------------------------
;пջı1
[State -1, HUpper]
type = ChangeState
value = 3100
triggerall = !var(30)
triggerall = Power >= 1000
triggerall = command = "HQCF_x"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200)|| (stateno = 230) || (stateno = 240)|| (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = StateNo = 3000 && ((Anim = 3000 && (AnimElemTime(6) >= 0 && AnimElemTime(22) < 0))||(Anim = 3010 && (AnimElemTime(6) >= 0 && AnimElemTime(30) < 0))||(Anim = 3020 && (AnimElemTime(6) >= 0 && AnimElemTime(38) < 0)))
trigger4 = StateNo = 3100 && ((Anim = 3100 && (AnimElemTime(6) >= 1 && AnimElemTime(15) < 0)))
trigger5 = StateNo = 1000 && (AnimElemTime(5) >= 0 && AnimElemTime(7) < 0)
trigger6 = StateNo = 1100 && (AnimElemTime(2) >= 0 && AnimElemTime(3) < 0)
trigger7 = StateNo = 1500 && (AnimElemTime(6) >= 0 && AnimElemTime(9) < 0)

;---------------------------------------------------------------------------
;пջı2
[State -1, HUpper]
type = ChangeState
value = 3110
triggerall = !var(30)
triggerall = Power >= 2000
triggerall = command = "HQCF_y" 
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200)|| (stateno = 230) || (stateno = 240)|| (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = StateNo = 3000 && ((Anim = 3000 && (AnimElemTime(6) >= 0 && AnimElemTime(22) < 0))||(Anim = 3010 && (AnimElemTime(6) >= 0 && AnimElemTime(30) < 0))||(Anim = 3020 && (AnimElemTime(6) >= 0 && AnimElemTime(38) < 0)))
trigger4 = StateNo = 3100 && ((Anim = 3100 && (AnimElemTime(6) >= 1 && AnimElemTime(15) < 0)))
trigger5 = StateNo = 1000 && (AnimElemTime(5) >= 0 && AnimElemTime(7) < 0)
trigger6 = StateNo = 1100 && (AnimElemTime(2) >= 0 && AnimElemTime(3) < 0)
trigger7 = StateNo = 1500 && (AnimElemTime(6) >= 0 && AnimElemTime(9) < 0)

;---------------------------------------------------------------------------

;ʿ3
[State ʿ3]
type = ChangeState
value = 3320
triggerall = !var(30)
triggerall = var(9) = 0
triggerall = command = "Hupper_c"
triggerall = power >= 3000
triggerall = roundstate = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = (stateno = 200) || (stateno = 230) || (stateno = 240) || (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = StateNo = 3000 && ((Anim = 3000 && (AnimElemTime(6) >= 0 && AnimElemTime(22) < 0))||(Anim = 3010 && (AnimElemTime(6) >= 0 && AnimElemTime(30) < 0))||(Anim = 3020 && (AnimElemTime(6) >= 0 && AnimElemTime(38) < 0)))
trigger4 = StateNo = 3100 && ((Anim = 3100 && (AnimElemTime(6) >= 0 && AnimElemTime(15) < 0)))
trigger5 = StateNo = 1000 && (AnimElemTime(5) >= 0 && AnimElemTime(7) < 0)
trigger6 = StateNo = 1100 && (AnimElemTime(2) >= 0 && AnimElemTime(3) < 0)
trigger7 = StateNo = 1500 && (AnimElemTime(6) >= 0 && AnimElemTime(9) < 0)

;---------------------------------------------------------------------------

;ʿ1
[State ʿ1]
type = ChangeState
value = 3300
triggerall = !var(30)
triggerall = command = "Hupper_a"
triggerall = power >= 1000
triggerall = roundstate = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = (stateno = 200) || (stateno = 230) || (stateno = 240) || (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = StateNo = 3000 && ((Anim = 3000 && (AnimElemTime(6) >= 0 && AnimElemTime(22) < 0))||(Anim = 3010 && (AnimElemTime(6) >= 0 && AnimElemTime(30) < 0))||(Anim = 3020 && (AnimElemTime(6) >= 0 && AnimElemTime(38) < 0)))
trigger4 = StateNo = 3100 && ((Anim = 3100 && (AnimElemTime(6) >= 0 && AnimElemTime(15) < 0)))
trigger5 = StateNo = 1000 && (AnimElemTime(5) >= 0 && AnimElemTime(7) < 0)
trigger6 = StateNo = 1100 && (AnimElemTime(2) >= 0 && AnimElemTime(3) < 0)
trigger7 = StateNo = 1500 && (AnimElemTime(6) >= 0 && AnimElemTime(9) < 0)

;---------------------------------------------------------------------------

;ʿ2
[State ʿ2]
type = ChangeState
value = 3310
triggerall = !var(30)
triggerall = command = "Hupper_b"
triggerall = power >= 2000
triggerall = roundstate = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = (stateno = 200) || (stateno = 230) || (stateno = 240) || (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = StateNo = 3000 && ((Anim = 3000 && (AnimElemTime(6) >= 0 && AnimElemTime(22) < 0))||(Anim = 3010 && (AnimElemTime(6) >= 0 && AnimElemTime(30) < 0))||(Anim = 3020 && (AnimElemTime(6) >= 0 && AnimElemTime(38) < 0)))
trigger4 = StateNo = 3100 && ((Anim = 3100 && (AnimElemTime(6) >= 0 && AnimElemTime(15) < 0)))
trigger5 = StateNo = 1000 && (AnimElemTime(5) >= 0 && AnimElemTime(7) < 0)
trigger6 = StateNo = 1100 && (AnimElemTime(2) >= 0 && AnimElemTime(3) < 0)
trigger7 = StateNo = 1500 && (AnimElemTime(6) >= 0 && AnimElemTime(9) < 0)

;---------------------------------------------------------------------------
;ʳŬ
;
[State -1, ko]
type = ChangeState
value = 1600
triggerall = !var(30)
triggerall = Pos Y= 0
triggerall = command = "QCB_x" || command = "QCB_y"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) || (stateno = [300,399]) || (stateno = [400,499]) || (stateno = [710,720])
trigger2 = movecontact
trigger3 = (stateno = 3000)|| (stateno = 3100)
trigger3 = var(1) = 1


;---------------------------------------------------------------------------
;()
[State -1, Upper]
type = ChangeState
value = 1100
triggerall = !var(30)
triggerall = command = "upper_x" 
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200)|| (stateno = [300,399]) || (stateno = [400,439]) || (stateno = [710,720])
trigger2 = movecontact
trigger3 = (stateno = 3000)|| (stateno = 3100)
trigger3 = var(1) = 1

;---------------------------------------------------------------------------
;()
[State -1, Upper]
type = ChangeState
value = 1101
triggerall = !var(30)
triggerall = command = "upper_y"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200)|| (stateno = [300,399]) || (stateno = [400,439]) || (stateno = [710,720])
trigger2 = movecontact
trigger3 = (stateno = 3000)|| (stateno = 3100)
trigger3 = var(1) = 1

;------------------------------------------
;
[State -1, double]
type = ChangeState
value = 1102
triggerall = !var(30)
trigger1 = command = "double"
trigger1 = stateno = 1103

;---------------------------------------------------------------------------
;̿
[State -1, ri]
type = ChangeState
value = 1200
triggerall = !var(30)
triggerall = command = "QCB_a" || command = "QCB_b"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) || (stateno = [300,399]) || (stateno = [400,499]) || (stateno = [710,720])
trigger2 = movecontact
trigger3 = (stateno = 3000)|| (stateno = 3100)
trigger3 = var(1) = 1 && Pos Y = 0

;---------------------------------------------------------------------------
;ڿ
;
[State -1, ko]
type = ChangeState
value = 1000
triggerall = !var(30)
triggerall = Pos Y= 0
triggerall = NumProjID(1050) != 1
triggerall = command = "QCF_x" || command = "QCF_y"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) || (stateno = [300,399]) || (stateno = [400,439]) || (stateno = [710,720])
trigger2 = movecontact
trigger3 = (stateno = 3000)|| (stateno = 3100)
trigger3 = var(1) = 1

;---------------------------------------------------------------------------
;
;
[State -1, fdb]
type = ChangeState
value = 1300
triggerall = !var(30)
triggerall = Pos Y= 0
triggerall = command = "FDBF_a" || command = "FDBF_b"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) || (stateno = [300,399]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = (stateno = 3000)|| (stateno = 3100)
trigger3 = var(1) = 1

;---------------------------------------------------------------------------
;Ǽǳ()
;
[State -1, ko]
type = ChangeState
value = 1700
triggerall = !var(30)
triggerall = Pos Y= 0
triggerall = command = "DB_a"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) || (stateno = [300,399]) || (stateno = [400,499]) || (stateno = [710,720])
trigger2 = movecontact
trigger3 = (stateno = 3000)|| (stateno = 3100)
trigger3 = var(1) = 1

;---------------------------------------------------------------------------
;Ǽǳ()
;
[State -1, ko]
type = ChangeState
value = 1701
triggerall = !var(30)
triggerall = Pos Y= 0
triggerall = command = "DB_b"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) || (stateno = [300,399]) || (stateno = [400,499]) || (stateno = [710,720])
trigger2 = movecontact
trigger3 = (stateno = 3000)|| (stateno = 3100)
trigger3 = var(1) = 1


;---------------------------------------------------------------------------
;̿()
;
[State -1, ri]
type = ChangeState
value = 1400
triggerall = !var(30)
triggerall = command = "QCB_b"
triggerall = Pos Y <= -25
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = (stateno = 3000)|| (stateno = 3100)
trigger2 = var(1) = 1

;------------------------------------------
;̿(߳)
[State -1, Raiouken]
type = ChangeState
value = 1410
triggerall = !var(30)
trigger1 = command = "QCB_a"
triggerall = Pos Y <= -25
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = (stateno = 3000)|| (stateno = 3100)
trigger2 = var(1) = 1

;---------------------------------------------------------------------------
;
;
[State -1, s]
type = ChangeState
value = 1500
triggerall = !var(30)
triggerall = Pos Y= 0
triggerall = command = "DB_x"|| command = "DB_y"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) || (stateno = [300,399]) || (stateno = [400,499]) || (stateno = [710,720])
trigger2 = movecontact
trigger3 = (stateno = 3000)|| (stateno = 3100)
trigger3 = var(1) = 1


;---------------------------------------------------------------------
;Upward Kick
[State -1]
type = ChangeState
value = 710
triggerall = !var(30)
triggerall = statetype != A && command = "holddown" && command = "b"  && command = "holdfwd"
trigger1 = ctrl = 1
trigger2 = stateno = 400 && movecontact = 1
trigger3 = stateno = 410 && movecontact = 1
trigger4 = stateno = 440 && movecontact = 1
trigger5 = stateno = 200 && movecontact = 1
trigger6 = stateno = 205 && movecontact = 1
trigger7 = stateno = 215 && movecontact = 1
trigger8 = stateno = 235 && movecontact = 1
trigger9 = stateno = 245 && movecontact = 1

;---------------------------------------------------------------------
;down Kick
[State -1]
type = ChangeState
value = 720
triggerall = !var(30)
triggerall = statetype != A && command = "holddown" && command = "a"  && command = "holdfwd"
trigger1 = ctrl = 1
trigger2 = stateno = 400 && movecontact = 1
trigger3 = stateno = 410 && movecontact = 1
trigger4 = stateno = 440 && movecontact = 1
trigger5 = stateno = 200 && movecontact = 1
trigger6 = stateno = 205 && movecontact = 1
trigger7 = stateno = 215 && movecontact = 1
trigger8 = stateno = 235 && movecontact = 1
trigger9 = stateno = 245 && movecontact = 1

;---------------------------------------------------------------------

;Jump_B Over
[State -1]
type = ChangeState
value = 612
triggerall = !var(30)
triggerall = statetype = A
triggerall = ctrl
trigger1 = command = "holdback" && command = "a"
trigger2 = p2dist x < 0
trigger2 = command = "fwd_a"

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
;޸
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = !var(30)
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
;齺
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = !var(30)
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; 
[State -1, ki]
type = ChangeState
value = 950
triggerall = !var(30)
triggerall = Power < 3000 && (command = "charge1" && command = "charge2")
trigger1 = statetype = S
trigger1 = ctrl


;---------------------------------------------------------------------------
;back-Roll
;Ĺ ȸ
[State -1, back-Roll]
type = ChangeState
value = 701
triggerall = !var(30)
trigger1 = command = "back-Roll"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Roll
; ȸ
[State -1, Roll]
type = ChangeState
value = 700
triggerall = !var(30)
trigger1 = command = "Roll"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Dodge
;ڸ ȸ
[State -1, Dodge]
type = ChangeState
value = 703
triggerall = !var(30)
trigger1 = command = "recovery"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;()
[State -1, air-nage]
type = ChangeState
value = 900
triggerall = !var(30)
triggerall = command = "y" && statetype = A && ctrl
triggerall = p2bodydist X < 5 && p2movetype != H && p2statetype = A
trigger1 = command = "holdback" || command = "holdfwd" || command = "holddown"

;()
[State -1, air-nage]
type = ChangeState
value = 901
triggerall = !var(30)
triggerall = command = "b" && statetype = A && ctrl
triggerall = p2bodydist X < 5 && p2movetype != H && p2statetype = A
trigger1 = command = "holdback" || command = "holdfwd" || command = "holddown"


;---------------------------------------------------------------------------
;
[State -1, Throw]
type = ChangeState
value = 800
triggerall = !var(30)
triggerall = command = "y" || command = "b"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 6
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 10
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H


;---------------------------------------------------------------------------
;F+LK
[State -1, FLK]
type = ChangeState
value = 260
triggerall = !var(30)
triggerall = command = "a"
triggerall = command = "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 300
triggerall = !var(30)
triggerall = command = "yb"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (StateNo = 100) && Time > 4

;---------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 702
triggerall = !var(30)
triggerall = command = "yb"
trigger1 = statetype = A
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
;Stand Light Punch (Close)
[State -1, Stand Light Punch]
type = ChangeState
value = 305
triggerall = !var(30)
triggerall = command = "x"
triggerall = command != "holddown" && p2bodydist x < 17
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 && AnimElemTime(3) > 0
trigger3 = stateno = 305 && AnimElemTime(3) > 0
trigger4 = stateno = 230 && AnimElemTime(4) > 0;   0:(easy) 1:(nomal)
trigger5 = stateno = 335 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)
trigger6 = stateno = 400 && AnimElemTime(3) > 0;   0:(easy) 1:(nomal)
trigger7 = stateno = 430 && AnimElemTime(3) > 0;   0:(easy) 1:(nomal)

;---------------------------------------------------------------------------
;Stand Strong Punch (Close)
[State -1, Stand Strong Punch]
type = ChangeState
value = 315
triggerall = !var(30)
triggerall = command = "y"
triggerall = command != "holddown" && p2bodydist x < 25
trigger1 = statetype = S
trigger1 = ctrl
;trigger2 = (stateno = 200) && time > 5
;trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Stand Light Kick (Close)
[State -1, Stand Light Kick]
type = ChangeState
value = 335
triggerall = !var(30)
triggerall = command = "a"
triggerall = command != "holddown" && p2bodydist x < 20
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)
trigger3 = stateno = 305 && AnimElemTime(3) > 0;   0:(easy) 1:(nomal)
trigger4 = stateno = 230 && AnimElemTime(5) > 0
trigger5 = stateno = 335 && AnimElemTime(3) > 0
trigger6 = stateno = 400 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)
trigger7 = stateno = 430 && AnimElemTime(4) > 0;   0:(easy) 1:(nomal)

;---------------------------------------------------------------------------
;Standing Strong Kick (Close)
[State -1, Standing Strong Kick]
type = ChangeState
value = 345
triggerall = !var(30)
triggerall = command = "b"
triggerall = command != "holddown" && p2bodydist x < 25
trigger1 = statetype = S
trigger1 = ctrl
;trigger2 = (stateno = 200) && time > 5
;trigger3 = (stateno = 230) && time > 6




;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = !var(30)
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 && AnimElemTime(3) > 2
trigger3 = stateno = 305 && AnimElemTime(3) > 0
trigger4 = stateno = 230 && AnimElemTime(4) > 0;   0:(easy) 1:(nomal)
trigger5 = stateno = 335 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)
trigger6 = stateno = 400 && AnimElemTime(3) > 0;   0:(easy) 1:(nomal)
trigger7 = stateno = 430 && AnimElemTime(3) > 0;   0:(easy) 1:(nomal)

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = !var(30)
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;trigger2 = (stateno = 200) && time > 5
;trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = !var(30)
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)
trigger3 = stateno = 305 && AnimElemTime(3) > 0;   0:(easy) 1:(nomal)
trigger4 = stateno = 230 && AnimElemTime(5) > 0
trigger5 = stateno = 335 && AnimElemTime(3) > 0
trigger6 = stateno = 400 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)
trigger7 = stateno = 430 && AnimElemTime(4) > 0;   0:(easy) 1:(nomal)

;---------------------------------------------------------------------------
;Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = !var(30)
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;trigger2 = (stateno = 200) && time > 5
;trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = !var(30)
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = !var(30)
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 430 && AnimElemTime(3) > 0;   0:(easy) 1:(nomal)
trigger3 = stateno = 400 &&  Time >= 8
trigger4 = stateno = 200 && AnimElemTime(3) > 2
trigger5 = stateno = 305 && AnimElemTime(3) > 0
trigger6 = stateno = 230 && AnimElemTime(4) > 0;   0:(easy) 1:(nomal)
trigger7 = stateno = 335 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)


;---------------------------------------------------------------------------
;Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = !var(30)
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;trigger2 = (stateno = 400) || (stateno = 430)
;trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = !var(30)
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 400 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)
trigger3 = stateno = 430 && time > 5
trigger4 = stateno = 200 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)
trigger5 = stateno = 305 && AnimElemTime(2) > 0;   0:(easy) 1:(nomal)
trigger6 = stateno = 230 && AnimElemTime(5) > 0
trigger7 = stateno = 335 && AnimElemTime(3) > 0



;---------------------------------------------------------------------------
;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = !var(30)
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;trigger2 = (stateno = 400) || (stateno = 430)
;trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = IfElse(Var(25) = 0 && Vel X = 0,601,600)
triggerall = !var(30)
triggerall = Command = "x" && StateType = A && Ctrl = 1
trigger1 = StateNo != 105

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = IfElse(Var(25) = 0 && Vel X = 0,611,610)
triggerall = !var(30)
triggerall = Command = "y" && StateType = A && Ctrl = 1
trigger1 = StateNo != 105

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = IfElse(Var(25) = 0 && Vel X = 0,631,630)
triggerall = !var(30)
triggerall = Command = "a" && StateType = A && Ctrl = 1
trigger1 = StateNo != 105

;---------------------------------------------------------------------------
;Jump Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = IfElse(Var(25) = 0 && Vel X = 0,641,640)
triggerall = !var(30)
triggerall = Command = "b" && StateType = A && Ctrl = 1
trigger1 = StateNo != 105

;---------------------------------------------------------------------------
;[State -1, Throw]
;type = ChangeState
;value = 800
;triggerall = Time = 1
;triggerall = Random <= 299
;triggerall = StateNo != 100
;triggerall = Statetype = S && P2BodyDist X < 6
;trigger1 = Statetype = S && P2MoveType != A && P2StateType != A && P2MoveType != H && Ctrl
;trigger2 = StateType = S && PrevStateNo = 1030 && P2StateType != A && P2MoveType != H && Ctrl

;===========================================================================

;   AI action

;===========================================================================

